﻿/*
Post-Deployment Script Template							
--------------------------------------------------------------------------------------
 This file contains SQL statements that will be appended to the build script.		
 Use SQLCMD syntax to include a file in the post-deployment script.			
 Example:      :r .\myfile.sql								
 Use SQLCMD syntax to reference a variable in the post-deployment script.		
 Example:      :setvar TableName MyTable							
               SELECT * FROM [$(TableName)]					
--------------------------------------------------------------------------------------
*/

use SchedulingDB


delete from UIMenu

-- Root level menu
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (2, 'VistA', '', null, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (3, 'Appointments', '', null, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (4, 'Administration', '', null, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (5, 'Template Admin', '', null, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (6, 'About', '~/About.aspx', null, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (7, 'Help', '~/Help.aspx', null, 0, '')

-- VistA items
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (8, 'Sites', '~/Administration/SiteList.aspx', 2, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (9, 'Facilities', '~/Administration/FacilityList.aspx', 2, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (10, 'Clinics', '~/Administration/ClinicList.aspx', 2, 0, '')

-- Appointment items
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (11, 'Create Appointments', '~/Patient/PatientAppointments.aspx', 3, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (12, 'Reschedule Appointments', '', 3, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (13, 'Cancel Appointments', '', 3, 1, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (14, 'Patient Check-In', '', 3, 0, '')
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (15, 'Waiting Lists', '', 3, 0, '')

-- Administration Items
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (16, 'Resources', '~/Administration/Resources/ResourceList.aspx', 4, 0, '')

-- Template Admin
INSERT INTO UIMenu (Id, MenuText, ResourceAddress, ParentId, SeparatorAfter, CommandArgument) VALUES (21, 'Templates', '~/Administration/Templates/TemplateList.aspx', 5, 0, '')
